<?php

namespace App\Http\Controllers;

use App\DimxDim;
use App\JdwlJadwal;
use App\JdwlJadwalSesi;
use App\SysxConfig;
use Illuminate\Http\Request;
use PhpParser\Node\Expr\Cast\Object_;
use stdClass;

class JadwalController extends ResponseController
{
    //Get All Jadwal

    public function getDayByNumber($hari){
        if($hari == 1)return "Senin";
        else if($hari == 2)return "Selasa";
        else if($hari == 3)return "Rabu";
        else if($hari == 4)return "Kamis";
        else if($hari == 5)return "Jumat";
    }
    public function getAllJadwal(Request $request){
        $userLogin = \JWTAuth::parseToken()->authenticate();
        // Get Tahun ajaran yang aktif pada saat itu
        $tahunAjaran = SysxConfig::where('key','=','tahun_ajaran')->first();
        $semester = SysxConfig::where('key','=','semester_tahun_ajaran')->first();
        // Get Krs mahasiswa yang aktif pada tahun yang sudah di definisikan
        $dimKrs = DimxDim::join('prkl_krs_mhs','dimx_dim.dim_id','=','prkl_krs_mhs.dim_id')
        ->where('prkl_krs_mhs.ta','=',$tahunAjaran->value)
        ->where('prkl_krs_mhs.sem_ta','=',$semester->value)
        ->where('dimx_dim.user_id','=',$userLogin->user_id)
        ->first();
        //Get Jadwal
        $jadwalDB = JdwlJadwalSesi::join('jdwl_jadwal as jadwal','jdwl_jadwal_sesi.jadwal_id','=','jadwal.jadwal_id')
        ->join('krkm_kuliah as matakuliah','jadwal.kuliah_id','=','matakuliah.kuliah_id')
        ->join('mref_r_lokasi as lokasi','jadwal.lokasi_id','=','lokasi.lokasi_id')
        ->join('prkl_krs_detail as detailKrs','detailKrs.kuliah_id','=','matakuliah.kuliah_id')
        ->join('jdwl_r_sesi as sesi','sesi.sesi_id','=','jdwl_jadwal_sesi.sesi_id')
        ->orderBy('jadwal.jadwal_id','ASC')
        ->orderBy('jdwl_jadwal_sesi.sesi_id','ASC')
        ->where('jadwal.ta','=',$tahunAjaran->value)
        ->where('jadwal.sem_ta','=',$semester->value)
        ->where('detailKrs.krs_mhs_id','=',$dimKrs->krs_mhs_id)
        ->get([
            'matakuliah.nama_kul_ind as namaMatkul',
            'sesi.sesi_id as sesiId',
            'sesi.start as mulaiMatkul',
            'sesi.end as akhirMatkul',
            'jadwal.hari_id as hari',
        ]);
        $result = array();
        $i = 1;
        $lenDay = 6;
        while($i < $lenDay){
            $jadwalClass = new stdClass;
            $matkul = [];
            foreach($jadwalDB as $jadwal){
                if($jadwal->hari == $i){
                    $jadwalClass->hari = $this->getDayByNumber($i);
                    array_push($matkul,$jadwal);
                }
            }
            $jadwalClass->matkul = $matkul;
            array_push($result,$jadwalClass);
            $i++;
        }

        return $this->successResponse(200,$result);
    }

    public function getJadwalToday(Request $request){
        $date = date('D');
        $hari = $this->convertToIndo($date);
        $numberDay = $this->convertDayToInt($hari);
        $userLogin = \JWTAuth::parseToken()->authenticate();
        // Get Tahun ajaran yang aktif pada saat itu
        $tahunAjaran = SysxConfig::where('key','=','tahun_ajaran')->first();
        $semester = SysxConfig::where('key','=','semester_tahun_ajaran')->first();
        // Get Krs mahasiswa yang aktif pada tahun yang sudah di definisikan
        $dimKrs = DimxDim::join('prkl_krs_mhs','dimx_dim.dim_id','=','prkl_krs_mhs.dim_id')
        ->where('prkl_krs_mhs.ta','=',$tahunAjaran->value)
        ->where('prkl_krs_mhs.sem_ta','=',$semester->value)
        ->where('dimx_dim.user_id','=',$userLogin->user_id)
        ->first();
        //Get Jadwal
        $jadwalDB = JdwlJadwalSesi::join('jdwl_jadwal as jadwal','jdwl_jadwal_sesi.jadwal_id','=','jadwal.jadwal_id')
        ->join('krkm_kuliah as matakuliah','jadwal.kuliah_id','=','matakuliah.kuliah_id')
        ->join('mref_r_lokasi as lokasi','jadwal.lokasi_id','=','lokasi.lokasi_id')
        ->join('prkl_krs_detail as detailKrs','detailKrs.kuliah_id','=','matakuliah.kuliah_id')
        ->join('jdwl_r_sesi as sesi','sesi.sesi_id','=','jdwl_jadwal_sesi.sesi_id')
        ->orderBy('jadwal.jadwal_id','ASC')
        ->orderBy('jdwl_jadwal_sesi.sesi_id','ASC')
        ->where('jadwal.ta','=',$tahunAjaran->value)
        ->where('jadwal.sem_ta','=',$semester->value)
        ->where('detailKrs.krs_mhs_id','=',$dimKrs->krs_mhs_id)
        ->where('jadwal.hari_id','=',$numberDay)
        ->get([
            'matakuliah.nama_kul_ind as namaMatkul',
            'sesi.sesi_id as sesiId',
            'sesi.start as mulaiMatkul',
            'sesi.end as akhirMatkul',
            'jadwal.hari_id as hari',
        ]);
        return $this->successResponse(200,$jadwalDB);
    }
    public function convertDayToInt($hari){
        switch($hari){
            case 'Minggu':
                $hari_ini = 7;
                return $hari_ini;
            break;
     
            case 'Senin':			
                $hari_ini = 1;
                return $hari_ini;
            break;
     
            case 'Selasa':
                $hari_ini = 2;
                return $hari_ini;
            break;
     
            case 'Rabu':
                $hari_ini = 3;
                return $hari_ini;
            break;
     
            case 'Kamis':
                $hari_ini = 4;
                return $hari_ini;
            break;
     
            case 'Jumat':
                $hari_ini = 5;
                return $hari_ini;
            break;
     
            case 'Sabtu':
                $hari_ini = 6;
                return $hari_ini;
            break;
            
            default:
                $hari_ini = 11;
                return $hari_ini;		
            break;
        }
    }
    public function convertToIndo($hari){
        switch($hari){
            case 'Sun':
                $hari_ini = "Minggu";
                return $hari_ini;
            break;
     
            case 'Mon':			
                $hari_ini = "Senin";
                return $hari_ini;
            break;
     
            case 'Tue':
                $hari_ini = "Selasa";
                return $hari_ini;
            break;
     
            case 'Wed':
                $hari_ini = "Rabu";
                return $hari_ini;
            break;
     
            case 'Thu':
                $hari_ini = "Kamis";
                return $hari_ini;
            break;
     
            case 'Fri':
                $hari_ini = "Jumat";
                return $hari_ini;
            break;
     
            case 'Sat':
                $hari_ini = "Sabtu";
                return $hari_ini;
            break;
            
            default:
                $hari_ini = "Tidak di ketahui";		
            break;
        }
    }
}
